<?php
header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Connection: keep-alive');

// Disable buffering to ensure real-time events
ini_set('output_buffering', 'off');
ini_set('zlib.output_compression', false);
while (ob_get_level() > 0) {
    ob_end_flush();
}
implicit_flush(true);

require_once 'SheerIDVerifier.php';

$url = $_GET['url'] ?? '';

if (empty($url)) {
    echo "data: [ERROR] Please provide a URL.\n\n";
    echo "event: error\n";
    echo "data: Connection closed\n\n";
    exit;
}

$verificationId = SheerIDVerifier::parseVerificationId($url);

if (!$verificationId) {
    echo "data: [ERROR] Invalid Verification ID.\n\n";
    echo "event: error\n";
    echo "data: Connection closed\n\n";
    exit;
}

// Custom logger callback
$logger = function ($msg) {
    // Send data as SSE
    echo "data: " . $msg . "\n\n";
    flush();
};

$verifier = new SheerIDVerifier($verificationId);
$result = $verifier->verify(null, null, null, null, null, $logger);

if ($result['success']) {
    echo "event: complete\n";
    echo "data: " . json_encode($result) . "\n\n";
} else {
    echo "event: error\n";
    echo "data: " . $result['message'] . "\n\n";
}
