<?php

require_once 'SheerIDVerifier.php';

function main()
{
    echo str_repeat("=", 60) . "\n";
    echo "SheerID Student Verifier (PHP + Node.js)\n";
    echo str_repeat("=", 60) . "\n\n";

    global $argv;
    if (count($argv) > 1) {
        $url = $argv[1];
    } else {
        echo "Please enter SheerID Verification URL: ";
        $handle = fopen("php://stdin", "r");
        $url = trim(fgets($handle));
        fclose($handle);
    }

    if (empty($url)) {
        echo "❌ Error: URL not provided\n";
        exit(1);
    }

    $verificationId = SheerIDVerifier::parseVerificationId($url);
    if (!$verificationId) {
        echo "❌ Error: Invalid Verification ID format\n";
        exit(1);
    }

    echo "✅ Verification ID: $verificationId\n\n";

    $verifier = new SheerIDVerifier($verificationId);
    $result = $verifier->verify();

    echo "\n" . str_repeat("=", 60) . "\n";
    echo "Verification Result:\n";
    echo str_repeat("=", 60) . "\n";
    echo "Status: " . ($result['success'] ? '✅ Success' : '❌ Failed') . "\n";
    echo "Message: " . $result['message'] . "\n";
    if (!empty($result['redirect_url'])) {
        echo "Redirect URL: " . $result['redirect_url'] . "\n";
    }
    echo str_repeat("=", 60) . "\n";

    exit($result['success'] ? 0 : 1);
}

if (php_sapi_name() === 'cli') {
    main();
}
